// 07. Write a c program for sorting using shell-sort method.

#include <stdio.h>
#include <math.h>
#define N 10


// run-time for 500 N is 124264
void shell_sort(int nums[N]) {
    int i, loopCount, count = 0, gap = N;

    loopCount = (N % 2) == 0 ? N / 2 : (N / 2) + 1;
    loopCount = (int)log2(N) * 2 > loopCount ? log2(N) * 2 + 1 : loopCount;

    // ^^^^ it can write as "loopCount = N < 12 ? (int)log2(N) * 2: loopCount;"

    while (count < loopCount) {
        gap = gap / 2;
        gap = gap == 0 ? 1 : gap;
        for (i = 0; i < N - gap; i++) {
            if (nums[i] > nums[i + gap]) {
                nums[i] = nums[i] ^ nums[i + gap];
                nums[i + gap] = nums[i] ^ nums[i + gap];
                nums[i] = nums[i] ^ nums[i + gap];
            }
        }
        count++;
    }
}

int main() {
    int i, numbers[N];

    for (i = 0; i < N; i++) {
        printf("Enter %d number: ", i + 1);
        scanf("%d", &numbers[i]);
    }

    shell_sort(numbers);

    printf("Sorted Numbers: \n\t");
    for (i = 0; i < N; i++)
        printf("%d\t", numbers[i]);
    return 0;
}

/* output
Enter 1 number: 551
Enter 2 number: 618
Enter 3 number: 264
Enter 4 number: 437
Enter 5 number: 398
Enter 6 number: 425
Enter 7 number: 296
Enter 8 number: 334
Enter 9 number: 573
Enter 10 number: 391

Sorted Numbers:    264     296     334     391     398     425     437
    551     573     618     */